/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderMocIndex;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.allsky.MyInputStreamCachedException;
import cds.fits.Fits;
import cds.moc.SMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class BuilderIndex
extends Builder {
    private int[] borderSize = new int[]{0, 0, 0, 0};
    private String currentfile = null;
    private boolean partitioning;
    private double maxRatio;
    private int[] hdu = null;
    private SMoc area;
    private boolean flagAppend;
    private int maxOverlays;
    private int statNbFile;
    private int statNbZipFile;
    private int statBlocFile;
    private long statMemFile;
    private long statPixSize;
    private long statMaxSize;
    private long statTime;
    private int statMaxWidth;
    private int statMaxHeight;
    private int statMaxDepth;
    private int statMaxNbyte;
    boolean stopped = false;
    private ArrayList<String> badFiles = null;

    public BuilderIndex(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.INDEX;
    }

    @Override
    public void run() throws Exception {
        this.build();
        this.report();
        this.context.writeHpxFinderProperties();
        BuilderMocIndex builderMocIndex = new BuilderMocIndex(this.context);
        builderMocIndex.run();
        this.context.setMocIndex(builderMocIndex.getMoc());
    }

    private void addBadFile(String file, String error) {
        if (this.badFiles == null) {
            this.badFiles = new ArrayList();
        }
        this.badFiles.add(file + (error != null && error.length() > 0 ? " => " + error : ""));
    }

    private void report() throws Exception {
        if (this.badFiles != null) {
            int n = this.badFiles.size();
            this.context.warning("Index report: " + n + " input file" + (n > 1 ? "s" : "") + " not incorporated:");
            for (String s : this.badFiles) {
                this.context.warning("   " + s);
            }
        }
        if (this.statNbFile == 0) {
            throw new Exception("No available image found ! => Aborted");
        }
        int bloc = this.context.getPartitioning();
        long val = this.partitioning ? (long)(Math.min(bloc, this.statMaxWidth) * Math.min(bloc, this.statMaxHeight)) : (long)(this.statMaxWidth * this.statMaxHeight);
        val *= (long)this.statMaxNbyte;
        this.context.info("Max original image overlay estimation: " + this.maxOverlays + " => may required " + cds.tools.Util.getUnitDisk(val *= (long)this.maxOverlays) + " per thread");
    }

    @Override
    public boolean isAlreadyDone() {
        if (!this.context.isExistingIndexDir()) {
            return false;
        }
        if (!this.context.actionAlreadyDone(Action.INDEX)) {
            return false;
        }
        if (this.context.getMocIndex() == null) {
            try {
                this.context.loadMocIndex();
            }
            catch (Exception e) {
                return false;
            }
        }
        this.context.info("Pre-existing HEALPix index seems to be ready");
        return true;
    }

    @Override
    public void validateContext() throws Exception {
        if (this.context instanceof ContextGui) {
            this.context.setProgressBar(((ContextGui)this.context).mainPanel.getProgressBarIndex());
        }
        this.partitioning = this.context.isPartitioning();
        if (this.partitioning) {
            int bloc = this.context.getPartitioning();
            this.context.info("Partitioning large original image files in blocks of " + bloc + "x" + bloc + " pixels");
        }
        this.validateInput();
        this.validateOutput();
        this.validateLabel();
        boolean bl = this.flagAppend = !this.context.isExistingIndexDir();
        if (!this.flagAppend) {
            this.context.info("Pre-existing HpxFinder index => will add new images only...");
        }
        int order = this.context.getOrder();
        double originalPixelRes = -1.0;
        if (order == -1 || this.context.getFitsKeys() == null) {
            String img = this.context.getImgEtalon();
            if (img == null && (img = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
                this.context.info("Reference image => " + img);
            }
            if (img == null) {
                throw new Exception("No source image found in " + this.context.getInputPath());
            }
            try {
                long nside;
                Fits file = new Fits(this.context.getHDU());
                file.loadHeaderFITS(img, true);
                if (file.getCalib() == null) {
                    throw new Exception("null calib");
                }
                this.context.defaultFitsKey = this.context.scanDefaultFitsKey(file.headerFits);
                originalPixelRes = file.getCalib().GetResol()[0];
                if (order == -1 && (order = Util.order((int)(nside = (long)BuilderIndex.calculateNSide(originalPixelRes * 3600.0))) - this.context.getTileOrder()) < 3) {
                    order = 3;
                }
                this.context.setOrder(order);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.context.warning("The reference image has no astrometrical calibration [" + img + "] => order can not be computed");
            }
        }
        if (order == -1) {
            throw new Exception("Argument \"order\" is required");
        }
        if (order < this.context.getOrder()) {
            this.context.warning("The provided order [" + order + "] is less than the optimal order [" + this.context.getOrder() + "] => OVER-sample will be applied");
        } else if (order > this.context.getOrder()) {
            this.context.warning("The provided order [" + order + "] is greater than the optimal order [" + this.context.getOrder() + "] => SUB-sample will be applied");
        } else {
            double hipsPixelRes = CDSHealpix.pixRes(this.context.getOrder() + this.context.getTileOrder()) / 3600.0;
            this.context.info("HiPS order " + this.context.getOrder() + " (pixel ang.res" + (originalPixelRes != -1.0 ? " orig:" + Coord.getUnit(originalPixelRes) : "") + " hips:" + Coord.getUnit(hipsPixelRes) + (originalPixelRes != -1.0 ? " x" + cds.tools.Util.round(hipsPixelRes / originalPixelRes, 2) : "") + ")");
        }
        int w = this.context.getTileSide();
        this.context.info("Tile order " + this.context.getTileOrder() + " => tile size: " + w + "x" + w + " pixels");
        this.hdu = this.context.getHDU();
        if (this.hdu == null) {
            if (!this.context.isColor()) {
                this.context.info("MEF strategy => extension 0, otherwise 1");
            }
        } else if (this.hdu.length > 0 && this.hdu[0] == -1) {
            this.context.info("MEF strategy => all images found in the MEF");
        } else {
            StringBuilder s = new StringBuilder("MEF stategy: extensions ");
            for (int i = 0; i < this.hdu.length; ++i) {
                if (i > 0) {
                    s.append(',');
                }
                s.append(this.hdu[i] + "");
            }
            this.context.info(s + "");
        }
        if (this.context.getFitsKeys() != null) {
            StringBuilder res = null;
            for (String key : this.context.getFitsKeys()) {
                if (res == null) {
                    res = new StringBuilder();
                } else {
                    res.append(", ");
                }
                res.append(key);
            }
            this.context.info("Extended metadata extraction based on FITS keys: " + res);
        }
        this.area = this.context.getArea();
        this.context.info("HiPS coordinate frame => " + this.context.getFrameName());
    }

    public static int calculateNSide(double pixsize) {
        double arcsec2rad = 4.84813681109536E-6;
        double nsd = Math.sqrt(1.0471975511965976) / (arcsec2rad * pixsize);
        int order_req = Math.max(0, Math.min(29, 1 + (int)CDSHealpix.log2((long)nsd)));
        return 1 << order_req;
    }

    @Override
    public void showStatistics() {
        if (this.statNbFile <= 0) {
            return;
        }
        long statDuree = System.currentTimeMillis() - this.statTime;
        this.context.showIndexStat(this.statNbFile, this.statBlocFile, this.statNbZipFile, this.statMemFile, this.statPixSize, this.statMaxSize, this.statMaxWidth, this.statMaxHeight, this.statMaxDepth, this.statMaxNbyte, statDuree);
    }

    @Override
    protected void build() throws Exception {
        this.initStat();
        String input = this.context.getInputPath();
        String output = this.context.getOutputPath();
        int order = this.context.getOrder();
        this.borderSize = this.context.getBorderSize();
        this.maxRatio = this.context.getMaxRatio();
        this.maxOverlays = 0;
        File f = new File(output);
        if (!f.exists()) {
            f.mkdir();
        }
        String pathDest = this.context.getHpxFinderPath();
        this.create(input, pathDest, order);
        this.context.addPixelIn(this.statPixSize);
        this.context.addMaxImgSize(this.statMaxWidth, this.statMaxHeight, this.statMaxDepth, this.statMaxNbyte);
    }

    private void initStat() {
        this.statBlocFile = 0;
        this.statNbZipFile = 0;
        this.statNbFile = 0;
        this.statMemFile = 0L;
        this.statPixSize = 0L;
        this.statMaxSize = -1L;
        this.statTime = System.currentTimeMillis();
    }

    private void updateStat(File f, int code, int width, int height, int depth, int nbyte, int deltaBlocFile) {
        ++this.statNbFile;
        this.statBlocFile += deltaBlocFile;
        if ((code & 1) != 0) {
            ++this.statNbZipFile;
        }
        long size = f.length();
        this.statPixSize += (long)width * (long)height * (long)depth;
        this.statMemFile += size;
        if (this.statMaxSize < size) {
            this.statMaxSize = size;
            this.statMaxWidth = width;
            this.statMaxHeight = height;
            this.statMaxDepth = depth;
            this.statMaxNbyte = nbyte;
        }
    }

    private RandomAccessFile openFile(String filename) throws Exception {
        File f = new File(filename);
        if (!f.exists()) {
            cds.tools.Util.createPath(filename);
        }
        return new RandomAccessFile(f, "rw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAFile(RandomAccessFile out, String filename, Coord center, long cellMem, String stc, String fitsVal) throws IOException {
        try {
            int o2;
            int o1 = filename.lastIndexOf(47);
            int o1b = filename.lastIndexOf(92);
            if (o1b > o1) {
                o1 = o1b;
            }
            if ((o2 = filename.lastIndexOf(46)) == -1 || o2 <= o1) {
                int o3;
                int n = o3 = filename.charAt(filename.length() - 1) == ']' ? filename.lastIndexOf(91) : -1;
                if (o3 > o2) {
                    o2 = o3;
                }
            }
            if (o2 == -1 || o2 <= o1) {
                o2 = filename.length();
            }
            String name = filename.substring(o1 + 1, o2);
            if (fitsVal == null) {
                fitsVal = "";
            }
            String line = "{ \"name\": \"" + name + "\", \"path\": \"" + filename + "\", \"ra\": \"" + center.al + "\", \"dec\": \"" + center.del + "\", \"cellmem\": \"" + cellMem + "\", \"stc\": \"" + stc + "\"" + fitsVal + " }\n";
            int nbEntries = (int)(out.length() / (long)line.length()) + 1;
            if (this.maxOverlays < nbEntries) {
                this.maxOverlays = nbEntries;
            }
            if (this.flagAppend) {
                out.seek(out.length());
            } else if (this.checkIn(out, line)) {
                return;
            }
            out.write(line.getBytes());
            out.close();
            out = null;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private boolean checkIn(RandomAccessFile out, String line) throws IOException {
        long size = out.length();
        byte[] buf = new byte[(int)size];
        out.readFully(buf);
        int start = 0;
        for (int i = 0; i < buf.length; ++i) {
            if ((char)buf[i] != '\n') continue;
            if (new String(buf, start, i - start + 1).equals(line)) {
                return true;
            }
            start = i + 1;
        }
        return false;
    }

    private boolean create(String pathSource, String pathDest, int order) throws Exception {
        File[] list;
        File[] fileArray;
        File main = new File(pathSource);
        ArrayList<File> dir = new ArrayList<File>();
        if (this.context.isInputFile) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = main;
        } else {
            fileArray = list = main.listFiles();
        }
        if (list == null) {
            return true;
        }
        int nbPilot = this.context.nbPilot;
        int i = 0;
        int nbFiles = 0;
        this.context.setProgress(0.0, list.length - 1);
        block7: for (File file : list) {
            if (nbPilot >= 0 && nbFiles > nbPilot) {
                this.context.warning("Test Pilot limited to " + nbPilot + " images => partial HiPS");
                return false;
            }
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            this.context.setProgress(i++);
            if (!this.context.isInputFile && file.isDirectory()) {
                dir.add(file);
                continue;
            }
            this.currentfile = file.getPath();
            Fits fitsfile = new Fits();
            boolean flagDefaultHDU = this.hdu == null;
            boolean flagAllHDU = this.hdu != null && this.hdu.length > 0 && this.hdu[0] == -1;
            int cellSize = this.context.getPartitioning();
            int firstDepth = 0;
            for (int j = 0; flagAllHDU || flagDefaultHDU || j < this.hdu.length; ++j) {
                int ext = flagDefaultHDU ? 0 : (flagAllHDU ? j : this.hdu[j]);
                try {
                    int code = fitsfile.loadHeaderFITS(this.currentfile + (ext == 0 ? "" : "[" + ext + "]"));
                    if (flagAllHDU && (code & 0x10) != 0) continue;
                    if (fitsfile.getCalib() == null) {
                        if (!flagDefaultHDU) continue;
                        continue block7;
                    }
                    ++nbFiles;
                    if (firstDepth == 0) {
                        firstDepth = fitsfile.depth;
                    } else if (fitsfile.depth != firstDepth) continue;
                    Aladin.trace(4, "HiPS indexing " + this.currentfile + (ext == 0 ? "" : "[" + ext + "]..."));
                    try {
                        if (!this.partitioning) {
                            this.testAndInsert(fitsfile, pathDest, this.currentfile, null, order);
                            this.updateStat(file, code, fitsfile.width, fitsfile.height, fitsfile.depth, fitsfile.bitpix == 0 ? 4 : Math.abs(fitsfile.bitpix) / 8, 0);
                        } else {
                            int width = fitsfile.width - this.borderSize[3];
                            int height = fitsfile.height - this.borderSize[2];
                            for (int x = this.borderSize[1]; x < width; x += fitsfile.widthCell) {
                                for (int y = this.borderSize[0]; y < height; y += fitsfile.heightCell) {
                                    fitsfile.widthCell = x + cellSize > width || width - x < 2 * cellSize ? width - x : cellSize;
                                    fitsfile.heightCell = y + cellSize > height || height - y < 2 * cellSize ? height - y : cellSize;
                                    int depth = fitsfile.depth;
                                    fitsfile.depth = 1;
                                    fitsfile.depthCell = 1;
                                    fitsfile.xCell = x;
                                    fitsfile.yCell = y;
                                    fitsfile.zCell = 0;
                                    fitsfile.ext = ext;
                                    String currentCell = fitsfile.getCellSuffix();
                                    this.testAndInsert(fitsfile, pathDest, this.currentfile, currentCell, order);
                                    fitsfile.depthCell = fitsfile.depth = depth;
                                }
                            }
                            this.updateStat(file, code, width, height, fitsfile.depth, fitsfile.bitpix == 0 ? 4 : Math.abs(fitsfile.bitpix) / 8, 1);
                        }
                    }
                    catch (Exception e1) {
                        this.addBadFile(this.currentfile, e1.getMessage());
                        continue block7;
                    }
                }
                catch (MyInputStreamCachedException e) {
                    this.context.taskAbort();
                }
                catch (Exception e) {
                    Aladin.trace(3, e.getMessage() + " " + this.currentfile);
                    continue block7;
                }
                if (flagDefaultHDU) continue block7;
            }
        }
        list = null;
        if (dir.size() > 0) {
            for (File f1 : dir) {
                if (!f1.isDirectory()) continue;
                this.currentfile = f1.getPath();
                try {
                    if (this.create(this.currentfile, pathDest, order)) continue;
                    return false;
                }
                catch (Exception e) {
                    Aladin.trace(3, e.getMessage() + " " + this.currentfile);
                }
            }
        }
        return true;
    }

    private void testAndInsert(Fits fitsfile, String pathDest, String currentFile, String suffix, int order) throws Exception {
        Coord center = new Coord();
        String fitsVal = null;
        Calib c = fitsfile.getCalib();
        int pj = c.getProj();
        boolean isRECT = pj == 7 || pj == 17;
        ArrayList<double[]> cooList = new ArrayList<double[]>(4);
        Coord coo = new Coord();
        Coord[] corner = new Coord[4];
        Coord[] cornerCell = new Coord[4];
        StringBuilder stc = new StringBuilder("POLYGON J2000");
        boolean hasCell = fitsfile.hasCell();
        for (int i = 0; i < 4; ++i) {
            coo.x = i == 0 || i == 3 ? fitsfile.xCell : fitsfile.xCell + fitsfile.widthCell;
            coo.y = i < 2 ? fitsfile.yCell : fitsfile.yCell + fitsfile.heightCell;
            coo.y = (double)fitsfile.height - coo.y;
            c.GetCoord(coo);
            cooList.add(this.context.ICRS2galIfRequired(coo.al, coo.del));
            cornerCell[i] = new Coord(coo.al, coo.del);
            if (hasCell) {
                coo.x = i == 0 || i == 3 ? 0 : fitsfile.width;
                coo.y = i < 2 ? 0 : fitsfile.height;
                coo.y = (double)fitsfile.height - coo.y;
                c.GetCoord(coo);
            }
            stc.append(" " + coo.al + " " + coo.del);
            corner[i] = new Coord(coo.al, coo.del);
        }
        if (!isRECT && this.maxRatio > 0.0 && this.statNbFile > 0) {
            double w = Coord.getDist(corner[0], corner[1]) / (double)fitsfile.width;
            double h = Coord.getDist(corner[1], corner[2]) / (double)fitsfile.height;
            if (h > w * this.maxRatio || w > h * this.maxRatio) {
                throw new Exception("Suspicious image calibration (pixel size=" + Coord.getUnit(w) + "x" + Coord.getUnit(h) + ") => see -maxRatio=xx parameter");
            }
        }
        center.x = (double)fitsfile.width / 2.0;
        center.y = (double)fitsfile.height / 2.0;
        center.y = (double)fitsfile.height - center.y;
        c.GetCoord(center);
        if (this.context.getFitsKeys() != null) {
            StringBuilder res = null;
            for (String key : this.context.getFitsKeys()) {
                String val = fitsfile.headerFits.getStringFromHeader(key);
                if (val == null && (fitsfile.headerFits0 == null || fitsfile.headerFits0 != null && (val = fitsfile.headerFits0.getStringFromHeader(key)) == null)) continue;
                if (res == null) {
                    res = new StringBuilder();
                }
                res.append(", \"" + key + "\": \"" + val.replace("\"", "\\\"") + "\"");
            }
            if (res != null) {
                fitsVal = res.toString();
            }
        }
        long cellMem = fitsfile.widthCell * fitsfile.heightCell * fitsfile.depth * (fitsfile.bitpix == 0 ? 32 : Math.abs(fitsfile.bitpix) / 8);
        long[] npixs = null;
        double maxRadius = 0.0;
        for (Coord c2 : corner) {
            double dist = Coord.getDist(center, c2);
            if (!(dist > maxRadius)) continue;
            maxRadius = dist;
        }
        double radius = maxRadius;
        if (radius < 30.0 && !isRECT) {
            try {
                npixs = CDSHealpix.query_polygon(order, cooList, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (npixs == null) {
            try {
                if (hasCell || isRECT) {
                    center.x = (double)fitsfile.xCell + (double)fitsfile.widthCell / 2.0;
                    center.y = (double)fitsfile.yCell + (double)fitsfile.heightCell / 2.0;
                    center.y = (double)fitsfile.height - center.y;
                    c.GetCoord(center);
                    maxRadius = 0.0;
                    for (Coord c2 : cornerCell) {
                        double dist = Coord.getDist(center, c2);
                        if (!(dist > maxRadius)) continue;
                        maxRadius = dist;
                    }
                    if (isRECT) {
                        Coord c2 = new Coord();
                        c2.x = fitsfile.xCell;
                        c2.y = center.y;
                        c.GetCoord(c2);
                        double dist = Coord.getDist(center, c2);
                        if (dist > maxRadius) {
                            maxRadius = dist;
                        }
                    }
                    radius = maxRadius;
                }
                double[] cent = this.context.ICRS2galIfRequired(center.al, center.del);
                npixs = CDSHealpix.query_disc(order, cent[0], cent[1], Math.toRadians(radius), true);
            }
            catch (Exception e) {
                throw new Exception("BuilderIndex error in CDSHealpix.query_disc() order=" + order + " center=" + center + " radius=" + radius + "deg file=" + fitsfile.getFilename() + " => ignored");
            }
        }
        for (int i = 0; i < npixs.length; ++i) {
            long npix = npixs[i];
            if (this.area != null && !this.area.isIntersecting(order, npix) || !this.isInImage(fitsfile, Util.getCorners(order, npix), isRECT)) continue;
            String hpxname = cds.tools.Util.concatDir(pathDest, Util.getFilePath("", order, npix));
            RandomAccessFile out = this.openFile(hpxname);
            String filename = currentFile + (suffix == null ? "" : suffix);
            this.createAFile(out, filename, center, cellMem, stc.toString(), fitsVal);
            out.close();
        }
    }

    private boolean isInImage(Fits f, Coord[] corners, boolean isCAR) {
        int signeX = 0;
        int signeY = 0;
        try {
            int marge = 2;
            for (int i = 0; i < corners.length; ++i) {
                Coord coo = corners[i];
                if (isCAR && coo.al == 180.0) {
                    return true;
                }
                if (this.context.getFrame() != 0) {
                    double[] radec = this.context.gal2ICRSIfRequired(coo.al, coo.del);
                    coo.al = radec[0];
                    coo.del = radec[1];
                }
                f.getCalib().GetXY(coo);
                if (Double.isNaN(coo.x)) continue;
                coo.y = (double)f.height - coo.y;
                int width = f.widthCell + marge;
                int height = f.heightCell + marge;
                if (coo.x >= (double)(f.xCell - marge / 2) && coo.x <= (double)(f.xCell + width) && coo.y >= (double)(f.yCell - marge / 2) && coo.y <= (double)(f.yCell + height)) {
                    return true;
                }
                signeX += coo.x > (double)(f.xCell + width) ? 1 : (coo.x < (double)(f.xCell - marge / 2) ? -1 : 0);
                signeY += coo.y > (double)(f.yCell + height) ? 1 : (coo.y < (double)(f.yCell - marge / 2) ? -1 : 0);
            }
        }
        catch (Exception e) {
            return false;
        }
        return Math.abs(signeX) != 4 && Math.abs(signeY) != 4;
    }
}

